#Prevalence
epi.prev(pos = 56, tested = 227, method = "blaker", conf.level = 0.95, sp = 1 ,se = 0.95) #VDV-1
epi.prev(pos = 41, tested = 227, method = "blaker", conf.level = 0.95, sp = 1 ,se = 0.95) #DWV	
epi.prev(pos = 26, tested = 227, method = "blaker", conf.level = 0.95, sp = 1 ,se = 0.95) #Co-infected

#Prevalence mapping
Dataset <- read.table("GB prevalence data.txt", header=T)

library("mapplots")
data(coast)
xlim <- c(-8,3)
ylim <- c(49,60)

par(mfrow=c(1, 3),cex=0.7)

agg <- aggregate(list(z=dataset$VDV_pr),list(x=dataset$long,y=dataset$lat),sum)
basemap(xlim, ylim, main = "VDV-1", bg="white")
draw.shape(coast, col="white")
draw.bubble(agg$x, agg$y, agg$z, maxradius=1.2, pch=1, col="green")

agg <- aggregate(list(z=dataset$DWV_pr),list(x=dataset$long,y=dataset$lat),sum)
basemap(xlim, ylim, main = "DWV", bg="white")
draw.shape(coast, col="white")
draw.bubble(agg$x, agg$y, agg$z, maxradius=1.2, pch=1, col="blue")

agg <- aggregate(list(z=dataset$Coinf_pr),list(x=dataset$long,y=dataset$lat),sum)
basemap(xlim, ylim, main = "Coinfected", bg="white")
draw.shape(coast, col="white")
draw.bubble(agg$x, agg$y, agg$z, maxradius=1.2, pch=1, col="orange")


#Chi squared test
DWV_VDV_prev <- matrix(c(26, 30, 15, 156),
                       nrow = 2,
                       dimnames = list("DWV" = c("present", "absent"),
                                       "VDV" = c("present", "absent")))
DWV_VDV_prev
Xsq <- chisq.test(DWV_VDV_prev)
Xsq$observed
Xsq$expected
Xsq


# test of proportions for DWV vs VDV prevalence:
infected <- c(56, 41)
population <- c(227, 227)
prop.test(infected,population, alternative=c("greater"), conf.level = 0.95)


#Moran's I
dist_A <- read.table("inv_dist_weight_matrix_file", header=T)

VDV_A <- c(0, 0, 0.13, 0, 0.22, 0, 0.44, 
           0, 0.38, 0.5, 0.38, 0.65, 0, 
           0.13, 0, 0.22, 0.5, 0.11, 0.27, 
           0, 0.44, 1, 0.44, 0, 0)
names(VDV_A)<- c("A", "B", "C", "D", "E", "F", "H", "I",
                 "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U",
                 "V", "W", "X", "Y", "Z")
Moran.I(VDV_A, dist_A)

DWV_A <- c(0.7, 0, 0.5, 0, 0.11, 0.14, 0.33, 
           0, 0.13, 0, 0, 0.47, 0.13, 0.25, 0.1, 
           0.22, 0, 0.11, 0, 0, 0.33, 0.33, 0.33, 
           0, 0)
names(DWV_A)<- c("A", "B", "C", "D", "E", "F", "H", "I",
                 "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U",
                 "V", "W", "X", "Y", "Z")
Moran.I(DWV_A, dist_A)

DWVDV_A <- c(0, 0, 0.13, 0, 0.11, 0, 0.33, 0, 0.13, 0, 0, 
             0.47, 0, 0.13, 0, 0.22, 0, 0.11, 0, 0, 0.33, 
             0.33, 0.22, 0, 0)

names(DWVDV_A)<- c("A", "B", "C", "D", "E", "F", "H", "I",
                   "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U",
                   "V", "W", "X", "Y", "Z")

Moran.I(DWVDV_A, dist_A)


